<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Microsoft
 * @package    Microsoft_Log
 * @subpackage Writer
 * @copyright  Copyright (c) 2005-2010 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id$
 */

/**
 * @see Microsoft_AutoLoader
 */
require_once dirname(__FILE__) . '/../../AutoLoader.php';

/**
 * @category   Microsoft
 * @package    Microsoft_Log
 * @subpackage Writer
 * @copyright  Copyright (c) 2005-2010 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id$
 */
abstract class Microsoft_Log_Filter_Abstract 
    implements Microsoft_Log_Filter_Interface, Microsoft_Log_FactoryInterface
{
    /**
     * Validate and optionally convert the config to array
     * 
     * @param  array $config
     * @return array
     * @throws Microsoft_Log_Exception
     */
    static protected function _parseConfig($config)
    {
        if (!is_array($config)) {
            require_once 'Microsoft/Log/Exception.php';
            throw new Microsoft_Log_Exception('Configuration must be an array');
        }

        return $config;
    }
}
